/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.history;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.history.GitGraphLine;
import com.aptana.git.ui.internal.history.GitLane;
import com.aptana.git.ui.internal.history.GraphCellInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitGrapher {
    private static final int MAX_LANES = 64;
    private List<GitLane> pl = new ArrayList<GitLane>();
    private GraphCellInfo previous;

    GitGrapher() {
    }

    Map<GitCommit, GraphCellInfo> decorateCommits(List<GitCommit> commits) {
        GitLane.resetColors();
        HashMap<GitCommit, GraphCellInfo> decorations = new HashMap<GitCommit, GraphCellInfo>();
        for (GitCommit commit : commits) {
            GraphCellInfo decoration = this.decorateCommit(commit);
            decorations.put(commit, decoration);
        }
        return decorations;
    }

    private GraphCellInfo decorateCommit(GitCommit commit) {
        int i = 0;
        int newPos = -1;
        ArrayList<GitLane> currentLanes = new ArrayList<GitLane>();
        ArrayList<GitLane> previousLanes = new ArrayList<GitLane>(this.pl);
        int maxLines = (previousLanes.size() + commit.parentCount() + 2) * 2;
        HashSet<GitGraphLine> lines = new HashSet<GitGraphLine>(maxLines);
        GitLane currentLane = null;
        boolean didFirst = false;
        if (this.previous != null) {
            Iterator it = previousLanes.iterator();
            while (it.hasNext()) {
                GitLane lane = (GitLane)it.next();
                ++i;
                if (lane.isCommit(commit.sha())) {
                    if (!didFirst) {
                        didFirst = true;
                        currentLanes.add(lane);
                        currentLane = lane;
                        newPos = currentLanes.size();
                        lines.add(new GitGraphLine(true, i, newPos, lane.index()));
                        if (!commit.hasParent()) continue;
                        lines.add(new GitGraphLine(false, newPos, newPos, lane.index()));
                        continue;
                    }
                    lines.add(new GitGraphLine(true, i, newPos, lane.index()));
                    it.remove();
                    continue;
                }
                currentLanes.add(lane);
                lines.add(new GitGraphLine(true, i, currentLanes.size(), lane.index()));
                lines.add(new GitGraphLine(false, currentLanes.size(), currentLanes.size(), lane.index()));
            }
        }
        if (!didFirst && currentLanes.size() < 64 && commit.hasParent()) {
            GitLane newLane = new GitLane((String)commit.parents().get(0));
            currentLanes.add(newLane);
            newPos = currentLanes.size();
            lines.add(new GitGraphLine(false, newPos, newPos, newLane.index()));
        }
        boolean addedParent = false;
        if (commit.parentCount() > 1) {
            for (String parent : commit.parents().subList(1, commit.parentCount())) {
                boolean was_displayed = false;
                int x = 0;
                while (x < currentLanes.size()) {
                    GitLane lane = (GitLane)currentLanes.get(x);
                    if (lane.isCommit(parent)) {
                        lines.add(new GitGraphLine(false, x + 1, newPos, lane.index()));
                        was_displayed = true;
                        break;
                    }
                    ++x;
                }
                if (was_displayed) continue;
                if (currentLanes.size() >= 64) break;
                addedParent = true;
                GitLane newLane = new GitLane(parent);
                currentLanes.add(newLane);
                lines.add(new GitGraphLine(false, currentLanes.size(), newPos, newLane.index()));
            }
        }
        this.previous = new GraphCellInfo(newPos, lines);
        if (lines.size() > maxLines) {
            this.log("Number of lines: " + lines.size() + " vs allocated: " + maxLines);
        }
        this.previous.numColumns = addedParent ? currentLanes.size() - 1 : currentLanes.size();
        if (currentLane != null && commit.parentCount() > 0) {
            currentLane.setSha((String)commit.parents().get(0));
        } else {
            currentLanes.remove(currentLane);
        }
        previousLanes.clear();
        this.pl = currentLanes;
        return this.previous;
    }

    private void log(String string) {
        if (GitUIPlugin.getDefault() != null) {
            IdeLog.logWarning((Plugin)GitUIPlugin.getDefault(), (String)string);
        } else {
            System.out.println(string);
        }
    }
}

